local payload_x = 0.588000
local payload_y = -0.320000
local payload_z = {2.360000, 1.600000}

dofile(current_mod_path..'/Datalinks/AddProp.lua')

local ExtFuelTankID							= "{EFT_230GAL}"								-- 230 gal External Fuel Tank
local InternalFuelTank100					= "{IAFS_ComboPak_100}"							-- 100 gal Internal Fuel Tank which decreases gun ammo to 300 rounds

local NURSLauncherID_MK151					= "M261_MK151"									-- M261 pod - 19 x 2.75" Hydra rockets M151 HE - high-explosive
local NURSLauncherID_M229					= "{M261_M229}"									-- M261 pod - 19 x 2.75\" Hydra, UnGd Rkts M229, HEDP
local NURSLauncherID_M257					= "{M261_M257}"									-- M261 pod - 19 x 2.75\" Hydra, UnGd Rkts M257, Illum.
local NURSLauncherID_M274					= "{M261_M274}"									-- M261 pod - 19 x 2.75\" Hydra, UnGd Rkts M274, Smk
local NURSLauncherID_M282					= "{M261_M282}"									-- M261 pod - 19 x 2.75\" Hydra, UnGd Rkts M282, Pen
local NURSLauncherID_M433					= "{M261_M151_M433}"							-- M261 pod - 19 x 2.75\" Hydra, UnGd Rkts M151 HE, M433 RC Fuze
local NURSLauncherID_M151_M274_OUTBOARD		= "{M261_OUTBOARD_AB_M151_E_M274}"				-- M261: Outboard Launcher, Zones A/B: M151 Hydra (6PD), Zone E: M274 Hydra (6SK)
local NURSLauncherID_M151_M257_OUTBOARD		= "{M261_OUTBOARD_AB_M151_E_M257}"				-- M261: Outboard Launcher, Zones A/B: M151 Hydra (6PD), Zone E: M257 Hydra (6IL)
local NURSLauncherID_M274_M151_INBOARD		= "{M261_INBOARD_DE_M151_C_M274}"				-- M261: Inboard Launcher, Zone C: M274 Hydra (6SK), Zones D/E: M151 Hydra (6PD)
local NURSLauncherID_M257_M151_INBOARD		= "{M261_INBOARD_DE_M151_C_M257}"				-- M261: Inboard Launcher, Zone C: M257 Hydra (6IL), Zones D/E: M151 Hydra (6PD)

local HellfireLauncherID_AGM114K_0			= "{M299_EMPTY}"								-- empty Hellfire launcher
local HellfireLauncherID_AGM114K_4			= "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}"		-- AGM-114K Hellfire * 4
local HellfireLauncherID_AGM114K_3_L		= "{M299_3xAGM_114K_OUTBOARD_PORT}"				-- AGM-114K Hellfire * 3, two on top row and one on lower outboard
local HellfireLauncherID_AGM114K_3_R		= "{M299_3xAGM_114K_OUTBOARD_STARBOARD}"		-- AGM-114K Hellfire * 3, two on top row and one on lower outboard
local HellfireLauncherID_AGM114K_2			= "{M299_2xAGM_114K}"							-- AGM-114K Hellfire * 2, on top row
local HellfireLauncherID_AGM114K_1_L		= "{M299_1xAGM_114K_OUTBOARD_PORT}"				-- AGM-114K Hellfire * 1, on top row, outboard
local HellfireLauncherID_AGM114K_1_R		= "{M299_1xAGM_114K_OUTBOARD_STARBOARD}"		-- AGM-114K Hellfire * 1, on top row, outboard

local HellfireLauncherID_AGM114L_4			= "{M299_4xAGM_114L}"							-- AGM-114L Hellfire * 4
local HellfireLauncherID_AGM114L_3_L		= "{M299_3xAGM_114L_OUTBOARD_PORT}"				-- AGM-114L Hellfire * 3, two on top row and one on lower outboard
local HellfireLauncherID_AGM114L_3_R		= "{M299_3xAGM_114L_OUTBOARD_STARBOARD}"		-- AGM-114L Hellfire * 3, two on top row and one on lower outboard
local HellfireLauncherID_AGM114L_2			= "{M299_2xAGM_114L}"							-- AGM-114L Hellfire * 2, on top row
local HellfireLauncherID_AGM114L_1_L		= "{M299_1xAGM_114L_OUTBOARD_PORT}"				-- AGM-114L Hellfire * 1, on top row, outboard
local HellfireLauncherID_AGM114L_1_R		= "{M299_1xAGM_114L_OUTBOARD_STARBOARD}"		-- AGM-114L Hellfire * 1, on top row, outboard

local HellfireLauncherID_AGM114_1K3L_L		= "{M299_1xAGM_114K_3xAGM_114L_PRT}"			-- mixed AGM-114K/L Hellfire * 1+3
local HellfireLauncherID_AGM114_1K3L_R		= "{M299_1xAGM_114K_3xAGM_114L_STRBRD}"			-- mixed AGM-114K/L Hellfire * 1+3
local HellfireLauncherID_AGM114_2K2L		= "{M299_2xAGM_114K_2xAGM_114L}"				-- mixed AGM-114K/L Hellfire * 2+2
local HellfireLauncherID_AGM114_3K1L_R		= "{M299_3xAGM_114K_1xAGM_114L_STRBRD}"			-- mixed AGM-114K/L Hellfire * 3+1
local HellfireLauncherID_AGM114_3K1L_L		= "{M299_3xAGM_114K_1xAGM_114L_PRT}"			-- mixed AGM-114K/L Hellfire * 3+1
local FCR									= "{AN_APG_78}"									-- Fire Control Radar/Radar Frequency Interferometer (FCR/RFI)

local function getForbiddenTypes(origin_num, this_num, origin_clsid)
	-- these types are forbidden for 'i'-th station when you load some weapon on this_station (origin_num)

	local ret_tbl = {}

	if origin_clsid == NURSLauncherID_MK151 then
		ret_tbl =
		{
			NURSLauncherID_M257,
			NURSLauncherID_M274,
			NURSLauncherID_M229,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M151_M257_OUTBOARD
		}

		if (origin_num == 2 or origin_num == 3) and (this_num == 2 or this_num == 3)	then	-- choose for inboard -> forbid for inboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M274_M151_INBOARD
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M257_M151_INBOARD
		end
	end

	if origin_clsid == NURSLauncherID_M257 then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M229,
			NURSLauncherID_M274,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}

		if (origin_num == 1 or origin_num == 4) and (this_num == 1 or this_num == 4)	then	-- choose for outboard -> forbid for outboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M151_M257_OUTBOARD
		end
	end

	if origin_clsid == NURSLauncherID_M274 then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M229,
			NURSLauncherID_M257,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M257_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}

		if (origin_num == 1 or origin_num == 4) and (this_num == 1 or this_num == 4)	then	-- choose for outboard -> forbid for outboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M151_M274_OUTBOARD
		end
	end

	if origin_clsid == NURSLauncherID_M229 then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M257,
			NURSLauncherID_M274,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M151_M257_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}
	end

	if origin_clsid == NURSLauncherID_M282 then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M257,
			NURSLauncherID_M274,
			NURSLauncherID_M229,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M151_M257_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}
	end

	if origin_clsid == NURSLauncherID_M433 then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M257,
			NURSLauncherID_M274,
			NURSLauncherID_M229,
			NURSLauncherID_M282,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M151_M257_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}
	end

	if origin_clsid == NURSLauncherID_M151_M274_OUTBOARD then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M229,
			NURSLauncherID_M257,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M257_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}

		if (this_num == 1 or this_num == 4)	then					-- forbid for outboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M274
		end
	end

	if origin_clsid == NURSLauncherID_M151_M257_OUTBOARD then
		ret_tbl =
		{
			NURSLauncherID_MK151,
			NURSLauncherID_M229,
			NURSLauncherID_M274,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M274_M151_INBOARD,
			NURSLauncherID_M257_M151_INBOARD
		}

		if (this_num == 1 or this_num == 4)	then					-- forbid for outboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M257
		end
	end

	if origin_clsid == NURSLauncherID_M274_M151_INBOARD then
		ret_tbl =
		{
			NURSLauncherID_M229,
			NURSLauncherID_M257,
			NURSLauncherID_M274,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M151_M257_OUTBOARD,
		}

		if (this_num == 2 or this_num == 3)	then					-- forbid for inboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_MK151
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M257_M151_INBOARD
		end
	end

	if origin_clsid == NURSLauncherID_M257_M151_INBOARD then
		ret_tbl =
		{
			NURSLauncherID_M229,
			NURSLauncherID_M257,
			NURSLauncherID_M274,
			NURSLauncherID_M282,
			NURSLauncherID_M433,
			NURSLauncherID_M151_M274_OUTBOARD,
			NURSLauncherID_M151_M257_OUTBOARD,
		}

		if (this_num == 2 or this_num == 3)	then					-- forbid for inboard
			ret_tbl[#ret_tbl+1] = NURSLauncherID_MK151
			ret_tbl[#ret_tbl+1] = NURSLauncherID_M274_M151_INBOARD
		end
	end

	return ret_tbl
end

local function DoForbidOnOthers(this_station, clsid)
	local tbl = {}
	local iter = 1

	local isHellfire 	=	clsid == HellfireLauncherID_AGM114K_0
						or 	clsid == HellfireLauncherID_AGM114K_4 or clsid == HellfireLauncherID_AGM114K_3_L or clsid == HellfireLauncherID_AGM114K_3_R
						or 	clsid == HellfireLauncherID_AGM114K_2 or clsid == HellfireLauncherID_AGM114K_1_L or clsid == HellfireLauncherID_AGM114K_1_R
						or 	clsid == HellfireLauncherID_AGM114L_4 or clsid == HellfireLauncherID_AGM114L_3_L or clsid == HellfireLauncherID_AGM114L_3_R
						or 	clsid == HellfireLauncherID_AGM114L_2 or clsid == HellfireLauncherID_AGM114L_1_L or clsid == HellfireLauncherID_AGM114L_1_R
						or 	clsid == HellfireLauncherID_AGM114_1K3L_L or clsid == HellfireLauncherID_AGM114_1K3L_R or clsid == HellfireLauncherID_AGM114_2K2L
						or 	clsid == HellfireLauncherID_AGM114_3K1L_R or clsid == HellfireLauncherID_AGM114_3K1L_L

	if(clsid == ExtFuelTankID or isHellfire) then 	-- restrictions are only for NURS
		return {}
	end

	for i=1,4 do
		if i~=this_station then
			tbl[iter] = {station = i, loadout = getForbiddenTypes(this_station, i, clsid)}
			iter = iter + 1
		end
	end

	return tbl
end

local function symmetric(clsid, this_station, opposite_station, arg_value)
	return  {
		CLSID     = clsid,
		arg_value = arg_value or 0.1,
		required  = {{station = opposite_station, loadout = {clsid}}},
		forbidden = DoForbidOnOthers(this_station, clsid)
	}
end

local function setRktLoadout(clsid, this_station, opposite_station, arg_value)
	return  {
		CLSID     = clsid,
		arg_value = arg_value or 0.1,
		required  = {},
		forbidden = DoForbidOnOthers(this_station, clsid)
	}
end

local function default_loadout_variants(station,opposite_station)
	local INB_OUTB_Variants = {}
	if station == 1 or station == 4 then
		INB_OUTB_Variants = {NURSLauncherID_M151_M274_OUTBOARD, NURSLauncherID_M151_M257_OUTBOARD}
	else
		INB_OUTB_Variants = {NURSLauncherID_M274_M151_INBOARD, NURSLauncherID_M257_M151_INBOARD}
	end

	local LEFT_RIGHT_Variants = {}
	if station == 1 or station == 2 then	-- left
		LEFT_RIGHT_Variants = {{HellfireLauncherID_AGM114K_3_L, HellfireLauncherID_AGM114L_3_L},{HellfireLauncherID_AGM114K_1_L, HellfireLauncherID_AGM114L_1_L},{HellfireLauncherID_AGM114_1K3L_L, HellfireLauncherID_AGM114_3K1L_L}}
	else
		LEFT_RIGHT_Variants = {{HellfireLauncherID_AGM114K_3_R, HellfireLauncherID_AGM114L_3_R},{HellfireLauncherID_AGM114K_1_R, HellfireLauncherID_AGM114L_1_R},{HellfireLauncherID_AGM114_1K3L_R, HellfireLauncherID_AGM114_3K1L_R}}
	end

	local ret_val = { setRktLoadout(NURSLauncherID_MK151,		station,	opposite_station,	0),
					  setRktLoadout(NURSLauncherID_M257,		station,	opposite_station,	0),
					  setRktLoadout(NURSLauncherID_M274,		station,	opposite_station,	0),
					  setRktLoadout(NURSLauncherID_M229,		station,	opposite_station,	0),
					  setRktLoadout(NURSLauncherID_M433,		station,	opposite_station,	0),
					  setRktLoadout(INB_OUTB_Variants[1],		station,	opposite_station,	0),
					  setRktLoadout(INB_OUTB_Variants[2],		station,	opposite_station,	0),

					  { CLSID = HellfireLauncherID_AGM114K_4,	arg_value = 0 },
					  { CLSID = HellfireLauncherID_AGM114L_4,	arg_value = 0 },
					  { CLSID = LEFT_RIGHT_Variants[1][1],		arg_value = 0 },
					  { CLSID = LEFT_RIGHT_Variants[1][2],		arg_value = 0 },
					  { CLSID = HellfireLauncherID_AGM114K_2,	arg_value = 0 },
					  { CLSID = HellfireLauncherID_AGM114L_2,	arg_value = 0 },
					  { CLSID = LEFT_RIGHT_Variants[2][1],		arg_value = 0 },
					  { CLSID = LEFT_RIGHT_Variants[2][2],		arg_value = 0 },
					  { CLSID = HellfireLauncherID_AGM114_2K2L,	arg_value = 0 },
					  { CLSID = LEFT_RIGHT_Variants[3][1],		arg_value = 0 },
					  { CLSID = LEFT_RIGHT_Variants[3][2],		arg_value = 0 },
					  { CLSID = HellfireLauncherID_AGM114K_0,	arg_value = 0 },

					  { CLSID = ExtFuelTankID,					arg_value = 0 }
	}

	return ret_val
end

local function getPylonArg(num)
	return {
		FiZ = 0,	-- TODO: what is it?

		arg = 640 + num - 1,
		arg_value = 0,
		use_full_connector_position = true,
		connector = "Pylon"..num,
		DisplayName = _(tostring(num)),
	}
end

local function getValuesTbl(params_cap_tbl)
	local rez_tbl = {}
	for i = 1, #params_cap_tbl do
		rez_tbl[i] = {id = i-1, dispName = params_cap_tbl[i]}
	end

	return rez_tbl
end

local function addComboList(key, caption, params_cap_tbl, def, width)
	return {
		id = key, control = 'comboList', label = caption,
		values = getValuesTbl(params_cap_tbl), defValue = def or 0,
		wCtrl = width or 150,
		playerOnly = true
	}
end

local function recoil_effect(arg, spring, recoil)
	return { name = "TurretRecoil", recoil_arg = arg, spring_coeff = spring, recoil_coeff = recoil  }
end

function fire_effect(fire_arg,duration,attenuation,light_pos)
	return { name = "FireEffect", arg = fire_arg,duration = duration or 0.02, attenuation = attenuation or 2 , light_pos = light_pos or {0.5,0,0}}
end

function smoke_effect()
	return { name = "SmokeEffect"}
end

local function shells_movement_effect( arg )
	return { name = "ShellsMovement", shells_movement_arg = arg }
end

local function DefaultTblUnits(tbl)
	local str = ""
	for i = 1, #tbl.tblUnits do
		local s = string.char(0x7B) .. tbl.tblUnits[i].unitId .. string.char(0x2C) .. tbl.tblUnits[i].value .. string.char(0x7D)
		str = str..s..string.char(0x2C)
	end
	return str
end
-------------------------------------------------------------
local AH_64D = {
	Name				= 'AH-64D_BLK_II',
	Shape				= 'AH-64D_bl2',
	shape_table_data	=
	{
		{
			file		= "AH-64D_bl2";
			username	= "AH-64D_BLK_II";
			index		= WSTYPE_PLACEHOLDER;
			life		= 20;
			vis			= 3;
			desrt		= "AH-64D_destr";
			fire		= { 300, 2};
			classname	= "lLandPlane";
			positioning	= "BYNORMAL";
		},
		{
			name		= "AH-64D_destr";
			file		= "AH-64-OBLOMOK";
			fire		= { 0, 1};
		}
	},

	Picture				= "AH-64D.png",
	DisplayName			= _("AH-64D BLK.II"),
	mapclasskey			= "P0091000021",
	WorldID				= WSTYPE_PLACEHOLDER,
	attribute			= {wsType_Air, wsType_Helicopter, wsType_Battleplane, WSTYPE_PLACEHOLDER, "Attack helicopters", "Refuelable", "Datalink", "AFAPD"},
	Categories			= {},
	CanopyGeometry		= makeHelicopterCanopyGeometry(LOOK_GOOD, LOOK_GOOD, LOOK_GOOD),
	encyclopediaAnimation = {
		args = {
			[507] = 1.000000, -- Pilot's eyepiece
			[517] = 1.000000, -- Copilot/Gunner's eyepiece
		},
	},

	-- Countermeasures,
	passivCounterm =
	{
		CMDS_Edit			= false,
		SingleChargeTotal	= 90,
		chaff				= {default = 30, increment = 30, chargeSz = 1},
		flare				= {default = 60, increment = 30, chargeSz = 1}
	},
	Sensors =
	{
		RADAR	= "AN/APG-78",
		OPTIC	= {"TADS DTV", "TADS FLIR"},
		RWR		= "Abstract RWR"
	},
	laserEquipment =
	{
		laserRangefinder = true,
		laserDesignator  = true,
	},
	EPLRS = true,

	HumanRadio =
	{
		editable = true,
		frequency = 225.0,
		minFrequency = 30,
		maxFrequency = 399.975,
		rangeFrequency = {
			{min =  30.0, max =  87.975, modulation	= MODULATION_FM},
			{min = 108.0, max = 151.975, modulation	= MODULATION_AM},
			{min = 225.0, max = 399.975, modulation	= MODULATION_AM}
		},
		modulation = MODULATION_AM,
	},
	panelRadio	= {
		[1] = {
			name = _("ARC-186"),
			range = { {min = 108.0, max = 151.975 }},
			channels = {
					[1] = { name = _("Channel 1"),		default = 127.5}, -- default
					[2] = { name = _("Channel 2"),		default = 135.0},	-- min. water
					[3] = { name = _("Channel 3"),		default = 136.0},	-- nalchik
					[4] = { name = _("Channel 4"),		default = 127.0},	-- sochi
					[5] = { name = _("Channel 5"),		default = 125.0},	-- maykop
					[6] = { name = _("Channel 6"),		default = 121.0},	-- anapa
					[7] = { name = _("Channel 7"),		default = 141.0},	-- beslan
					[8] = { name = _("Channel 8"),		default = 128.0},	-- krasnodar-pashk.
					[9] = { name = _("Channel 9"),		default = 126.0},	-- gelenjik
					[10] ={ name = _("Channel 10"),		default = 137.0}, -- mozdok
			}
		},
		[2] = {
			name = _("ARC-164"),
			range = { {min = 225.0, max = 399.975 }},
			channels = {
					[1] = { name = _("Channel 1"),		default = 225.0, connect = true},
					[2] = { name = _("Channel 2"),		default = 240.0},
					[3] = { name = _("Channel 3"),		default = 255.0},
					[4] = { name = _("Channel 4"),		default = 270.0},
					[5] = { name = _("Channel 5"),		default = 285.0},
					[6] = { name = _("Channel 6"),		default = 300.0},
					[7] = { name = _("Channel 7"),		default = 325.0},
					[8] = { name = _("Channel 8"),		default = 350.0},
					[9] = { name = _("Channel 9"),		default = 375.0},
					[10] ={ name = _("Channel 10"),		default = 390.0},
			}
		},
		[3] = {
			name = _("FM 1: ARC-201D"),
			range = {min =  30.0, max =  87.975, modulation	= MODULATION_FM},
			channels = {
				        [1] =  { name = _("Channel 1"),		default = 30.000},
				        [2] =  { name = _("Channel 2"),		default = 30.010},
				        [3] =  { name = _("Channel 3"),		default = 30.015},
				        [4] =  { name = _("Channel 4"),		default = 30.020},
				        [5] =  { name = _("Channel 5"),		default = 30.025},
				        [6] =  { name = _("Channel 6"),		default = 30.030},
				        [7] =  { name = _("Channel 7"),		default = 30.035},
				        [8] =  { name = _("Channel 8"),		default = 30.040},
				        [9] =  { name = _("Channel 9"),		default = 30.045},
				        [10] = { name = _("Channel 10"),	default = 30.050},
			}
		},
		[4] = {
			name = _("FM 2: ARC-201D"),
			range = {min =  30.0, max =  87.975, modulation	= MODULATION_FM},
			channels = {
				        [1] =  { name = _("Channel 1"),		default = 30.000},
				        [2] =  { name = _("Channel 2"),		default = 30.010},
				        [3] =  { name = _("Channel 3"),		default = 30.015},
				        [4] =  { name = _("Channel 4"),		default = 30.020},
				        [5] =  { name = _("Channel 5"),		default = 30.025},
				        [6] =  { name = _("Channel 6"),		default = 30.030},
				        [7] =  { name = _("Channel 7"),		default = 30.035},
				        [8] =  { name = _("Channel 8"),		default = 30.040},
				        [9] =  { name = _("Channel 9"),		default = 30.045},
				        [10] = { name = _("Channel 10"),	default = 30.050},
			}
		},
	},
	TACAN_AA = true,

	Pylons =
	{
		pylon(1, 0, payload_x, payload_y, -payload_z[1],
			getPylonArg(1),
			default_loadout_variants(1,4),
			1
		),
		pylon(2, 0, payload_x, payload_y, -payload_z[2],
			getPylonArg(2),
			default_loadout_variants(2,3),
			2
		),
		pylon(3, 0, payload_x, payload_y, payload_z[2],
			getPylonArg(3),
			default_loadout_variants(3,2),
			4
		),
		pylon(4, 0, payload_x, payload_y, payload_z[1],
			getPylonArg(4),
			default_loadout_variants(4,1),
			5
		),
		pylon(5, 0, 0.3717, -0.35, 0.0,
			{
				arg = 0,
				arg_value = 0,
				DisplayName = "IAFS",
			},
			{
				{ CLSID = InternalFuelTank100 },
				--{ CLSID = "{***}" },					-- TODO: add tank 130 gal and 58 rounds at all for the gun
			},
			3
		),
		pylon(6, 0, 0.350867, 2.526422, -0.000000,
			{
				arg = 0,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon_Radar",
				DisplayName = "MMA",
			},
			{
				{ CLSID = FCR },
			},
			6
		),
	},
--
	Guns =
	{
		gun_mount("M_230_new",
			{ count = 1200 },
			{
				muzzle_pos = {3.881, -1.821,  0.0},
				supply_position = {0.14, 0.1, 0.0},
				muzzle_pos_connector = "Gun_point_01",
				ejector_pos_connector = "ejector_1",
				max_burst_length = 1200,
				effects = {recoil_effect(350, 0.3, 0.95), fire_effect(46), smoke_effect(), shells_movement_effect( 349 )   }
			}
		)
	},
	ammo_type_default = 1,
	ammo_type ={
			_("M789 HEDP"),
			_("M788 TP"),
	},

	Tasks =
	{
		aircraft_task(CAS),
		aircraft_task(GroundAttack),
		aircraft_task(Escort),
		aircraft_task(AFAC),
		aircraft_task(AntishipStrike)
	},-- end of Tasks
	DefaultTask = aircraft_task(CAS),

	LandRWCategories =
	{
		[1] =
		{
			Name = "AircraftCarrier",
		}, -- end of [1]
		[2] =
		{
			Name = "HelicopterCarrier",
		}, -- end of [2]
	}, -- end of LandRWCategories
	TakeOffRWCategories =
	{
		[1] =
		{
			Name = "AircraftCarrier",
		}, -- end of [1]
		[2] =
		{
			Name = "HelicopterCarrier",
		}, -- end of [2]
	}, -- end of TakeOffRWCategories

	-- RTS
	EmptyWeight			                = "5930.47",
	MaxFuelWeight		                        = "1140",
	MaxHeight			                = "4500",
	MaxSpeed			                = "280",
	MaxTakeOffWeight	                        = "10432.6", -- p755 The aircraft maximum gross weight is 20,260 pounds, except for non- tactical ferry flights, which may not exceed 23,000 pounds.
	Rate				                = "50",

	-- Aircraft Descriptor
	M_empty						= 5930.47 + 0 + 0,	-- (aircraft itself + engines + basic equipment + crew = 13306 pounds) + (IAFS fuel container?) + (IAFS ammo container?)
	M_nominal					= 8654.7,           -- (estimated for "average" condition: BaroAlt=1000m, FAT=+20C, TQ=100%, HoverAlt=20ft, diagram "10min")
	M_max						= 9189.94,          -- (20.260lbs acording with FManual, was 10432.6 - maximum weight in ferry version)
	M_fuel_max					= 1140,				-- fwd + aft tanks
	--M_Boost_Mixt_max			        =
	length						= 17.87,
	height						= 4.15,
	--apu_rpm_delay				        =
	Vy_max						= 12.7,
	radar_can_see_ground		                = false,
	RCS						= 5,
	detection_range_max			        = 0,
	IR_emission_coeff			        = 0.2,
	Ny_max						= 3.5,
	range						= 480,
	tanker_type					= 2,
	air_refuel_receptacle_pos	                = { -0.051, 0.911, 0},
	--bigParkingRamp			        =
	country_of_origin			        = "USA",

	-- Helicopter Descriptor
	rotor_height				        = 1.6,
	rotor_diameter				        = 14.63,
	blades_number				        = 4,
	blade_area					= 3.39,
	rotor_RPM					= 289,
	tail_rotor_RPM				        = 1403,
	blade_chord					= 0.53,
	rotor_MOI					= 5800,
	rotor_pos					= {0.123,	1.47,	0},
	thrust_correction			        = 0.75,
	fuselage_Cxa0				        = 0.5,
	fuselage_Cxa90				        = 5.9,
	fuselage_area				        = 4,
	centering					= -0.1827,
	tail_pos					= {-9,	1.401,	0},
	tail_fin_area				        = 1.45,
	tail_stab_area				        = 2.94,

	MOI						= {6170,	28982,	33441},

	V_max						= 365,
	V_max_cruise				        = 296,
	H_stat_max_L				        = 4570,
	H_stat_max					= 3505,
	H_din_two_eng				        = 6400,
	H_din_one_eng				        = 3290,
	flight_time_typical			        = 110,
	flight_time_maximum			        = 189,

	lead_stock_main				        = 0.37,
	lead_stock_support			        = 0.147,
	scheme						= 0,

	Vy_land_max					= 12.8,
	sound_name					= "Aircrafts/Engines/RotorAH64",

	--cannon_sight_type			        =
	--cargo_max_weight			        =
	--cargo_radius_in_menu		                =
	--helicopter_hook_pos		                =
	--h_max_gear_hook			        =

	fire_rate					= 625,
	stores_number				        = 4,

	--
	wheel_steering_angle_max			= math.rad(180.0),
	nose_gear_pos					= {-9.203,	-0.960,	0},
	--[[nose_gear_amortizer_direct_stroke		= 0.0,				-- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke		= -(0.246 + 0.030),		-- up
	nose_gear_amortizer_normal_weight_stroke	= -(0.246 + 0.030) * 0.7,	-- down from nose_gear_pos
	nose_gear_wheel_diameter			= 0.3228,
	nose_gear_door_close_after_retract		= false,]]--

	main_gear_pos					= {1.361,	-1.832,	1.017},
	--[[main_gear_amortizer_direct_stroke		= 0.0,				-- down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke		= -(0.267 + 0.056),		-- up
	main_gear_amortizer_normal_weight_stroke	= -(0.267 + 0.056) * 0.7,	-- down from main_gear_pos
	main_gear_wheel_diameter			= 0.6448,
	main_gear_door_close_after_retract		= false,]]--

	engines_count = 2,
	engine_data =
	{
		power_take_off	        = 1169,
		power_max		= 1169,
		power_WEP		= 1297,
		power_TH_k =
		{
	        [1] = { 6.3136, -151.3, 1252.4 },
                [2] = { 4.9361, -143.84, 1263.3 },
                [3] = { 3.0994, -125.54, 1239.5 },
                [4] = { -2.3851, -55.487, 1006.7 },
		},
		SFC_k			= {  0,-0.0002618,0.5813},
		power_RPM_k		= { -0.0778, 0.2506,0.8099},
		power_RPM_min	= 9.1384,
		sound_name		= "Aircrafts/Engines/EngineGE",
	},
	engines_nozzles =
	{
		[1] =
		{
			diameter		= 0.6,
			exhaust_length_ab	= 0.1,
		}, -- end of [1]
		[2] =
		{
			diameter		= 0.6,
			exhaust_length_ab	= 0.1,
		}, -- end of [2]
	}, -- end of engines_nozzles

	cannon_sight_type	=	2,
	turret_data = {
			H_Min =  -86.0,
			H_Max =   86.0,
			V_Min =  -60.0,
			V_Max =   11.0,
			H_Vel =   20.0,
			V_Vel =   20.0,
		},
	crew_size = 2,
	crew_members =
	{
		[1] =
		{
			pilot_name              = "pilot_ah64",
			ejection_seat_name	= 0,
			drop_canopy_name	= 0,
			pos			= { 1.68, 0.33, 0},
			pilot_body_arg		= 50,
			canopy_arg		= 38,
            dismount_play                       = {1, 0.496, 0.500, 0.600},
			can_be_playable		= true,
			role			= "pilot",
			role_display_name	= _("Pilot"),
		},
		[2] =
		{
			pilot_name              = "pilot_ah64",
			ejection_seat_name	= 0,
			drop_canopy_name	= 0,
			pos			= { 3.290,-0.168,0},
			pilot_body_arg		= 472,
			canopy_arg		= 421,
            dismount_play       = {0, 0.497, 0.501, 0.600},
			can_be_playable		= true,
			role			= "copilot",
			role_display_name	= _("Copilot/Gunner"),
		},
	}, -- end of crew_members
	crew_stations = "HumanOrchestra",
	doors_movement  = 2,
	undercarriage_movement 		= 0,	-- nonretractable gear
	mechanimations = {
		   WindscreenWiper0 = {
                {Transition = {"Any", "Hang"}, Sequence = {{C = {{"Sleep", "for", 0.0}}}}},
                {Transition = {"Any", "Retract"}, Sequence = {{C = {{"Arg", 13, "to", 0.0, "at", 2.0 / 60.0 * 60.0, "sign", -1}}}}},
                {Transition = {"Any", "CustomStage0"}, Sequence = {{C = {{"Arg", 13, "to", 1.0, "at", 2.0 / 60.0 * 60.0, "sign", 1}}}, {C = {{"Arg", 13, "to", 0.0, "at", 2.0 / 60.0 * 60.0, "sign", -1}}}, {C = {{"ValuePhase", 0}}}}},
                {Transition = {"Any", "CustomStage1"}, Sequence = {{C = {{"Arg", 13, "to", 1.0, "at", 2.0 / 60.0 * 90.0, "sign", 1}}}, {C = {{"Arg", 13, "to", 0.0, "at", 2.0 / 60.0 * 90.0, "sign", -1}}}, {C = {{"ValuePhase", 0}}}}},
            },
            WindscreenWiper1 = {
                {Transition = {"Any", "Hang"}, Sequence = {{C = {{"Sleep", "for", 0.0}}}}},
                {Transition = {"Any", "Retract"}, Sequence = {{C = {{"Arg", 14, "to", 0.0, "at", 2.0 / 60.0 * 60.0, "sign", -1}}}}},
                {Transition = {"Any", "CustomStage0"}, Sequence = {{C = {{"Arg", 14, "to", 1.0, "at", 2.0 / 60.0 * 60.0, "sign", 1}}}, {C = {{"Arg", 14, "to", 0.0, "at", 2.0 / 60.0 * 60.0, "sign", -1}}}, {C = {{"ValuePhase", 0}}}}},
                {Transition = {"Any", "CustomStage1"}, Sequence = {{C = {{"Arg", 14, "to", 1.0, "at", 2.0 / 60.0 * 90.0, "sign", 1}}}, {C = {{"Arg", 14, "to", 0.0, "at", 2.0 / 60.0 * 90.0, "sign", -1}}}, {C = {{"ValuePhase", 0}}}}},
            },
			Door0 = { -- operator canopy
				{Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 421, "to", 0.9, "in", 2.0},},},}, Flags = {"Reversible"},},
				{Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 421, "to", 0.0, "in", 2.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
			},
			Door1 = { -- pilot canopy
				{Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 2.0},},},}, Flags = {"Reversible"},},
				{Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 2.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
			},

			Pylon0Elevation = {	-- Pylon LO
				{Transition = {"Any", "Any"},	Sequence = {{C = {{"Arg", 640, "from", -0.1667, "to", 0.0556, "in", 1.2},},},}, Flags = {"Reversible"},},

				{Transition = {"Any", "Taxi"},  Sequence = {{C = {{"Arg", 640, "to", -0.055, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},},-- ground stow position	-5deg, -5/90 = 0.055
				{Transition = {"Any", "Medium"},Sequence = {{C = {{"Sleep", "for", 0.5}}},
															{C = {{"Arg", 640, "to",  0.044, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},}, -- flight mode position 4deg, 4/90=0.044
				{Transition = {"Any", "Low"}, 	Sequence = {{C = {{"Arg", 640, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},},},	-- down movement
				{Transition = {"High", "Low"}, 	Sequence = {{C = {{"Arg", 640, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},}, Flags = {"Reversible"},},	-- down
				{Transition = {"Any", "High"},  Sequence = {{C = {{"Arg", 640, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},},},},	-- up movement
				{Transition = {"Low", "High"},  Sequence = {{C = {{"Arg", 640, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},}, },Flags = {"Reversible"},},	-- up
			},
			Pylon1Elevation = {	-- Pylon LI
				{Transition = {"Any", "Any"},	Sequence = {{C = {{"Arg", 641, "from", -0.1667, "to", 0.0556, "in", 1.2},},},}, Flags = {"Reversible"},},

				{Transition = {"Any", "Taxi"},  Sequence = {{C = {{"Arg", 641, "to", -0.055, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},},	-- ground stow position
				{Transition = {"Any", "Medium"},Sequence = {{C = {{"Sleep", "for", 0.5}}},
															{C = {{"Arg", 641, "to",  0.044, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},}, -- flight mode position
				{Transition = {"Any", "Low"}, 	Sequence = {{C = {{"Arg", 641, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},},},	-- down movement
				{Transition = {"High", "Low"}, 	Sequence = {{C = {{"Arg", 641, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},}, Flags = {"Reversible"},},	-- down
				{Transition = {"Any", "High"},  Sequence = {{C = {{"Arg", 641, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},},},},	-- up movement
				{Transition = {"Low", "High"},  Sequence = {{C = {{"Arg", 641, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},}, },Flags = {"Reversible"},},	-- up
			},
			Pylon2Elevation = {	-- Pylon RI
				{Transition = {"Any", "Any"},	Sequence = {{C = {{"Arg", 642, "from", -0.1667, "to", 0.0556, "in", 1.2},},},}, Flags = {"Reversible"},},

				{Transition = {"Any", "Taxi"},  Sequence = {{C = {{"Arg", 642, "to", -0.055, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},},	-- ground stow position
				{Transition = {"Any", "Medium"},Sequence = {{C = {{"Sleep", "for", 0.5}}},
															{C = {{"Arg", 642, "to",  0.044, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},}, -- flight mode position
				{Transition = {"Any", "Low"}, 	Sequence = {{C = {{"Arg", 642, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},},},	-- down movement
				{Transition = {"High", "Low"}, 	Sequence = {{C = {{"Arg", 642, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},}, Flags = {"Reversible"},},	-- down
				{Transition = {"Any", "High"},  Sequence = {{C = {{"Arg", 642, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},},},},	-- up movement
				{Transition = {"Low", "High"},  Sequence = {{C = {{"Arg", 642, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},}, },Flags = {"Reversible"},},	-- up
			},
			Pylon3Elevation = {	-- Pylon RO
				{Transition = {"Any", "Any"},	Sequence = {{C = {{"Arg", 643, "from", -0.1667, "to", 0.0556, "in", 1.2},},},}, Flags = {"Reversible"},},

				{Transition = {"Any", "Taxi"},  Sequence = {{C = {{"Arg", 643, "to", -0.055, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},},	-- ground stow position
				{Transition = {"Any", "Medium"},Sequence = {{C = {{"Sleep", "for", 0.5}}},
															{C = {{"Arg", 643, "to",  0.044, "speed", 1.0 / 40.0},},},}, Flags = {"Reversible"},}, -- flight mode position
				{Transition = {"Any", "Low"}, 	Sequence = {{C = {{"Arg", 643, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},},},	-- down movement
				{Transition = {"High", "Low"}, 	Sequence = {{C = {{"Arg", 643, "to",   -1.0, "speed", 1.0 / 20.0 , "sign", -1.0},},},}, Flags = {"Reversible"},},	-- down
				{Transition = {"Any", "High"},  Sequence = {{C = {{"Arg", 643, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},},},},	-- up movement
				{Transition = {"Low", "High"},  Sequence = {{C = {{"Arg", 643, "to",    1.0, "speed", 1.0 / 20.0 , "sign",  1.0},},}, },Flags = {"Reversible"},},	-- up
			},
			SearchLight0Elevation = {
				{Transition = {"Any", "Retract"},	Sequence = {{C = {{"Arg", 423, "from", 1.0,  "to",   0.0, "speed", 1.0},},},},},
				{Transition = {"Any", "Extend"},	Sequence = {{C = {{"Arg", 423, "from", 0.0,  "to",   1.0, "speed", 1.0},},},},},
			},
			SearchLight0Panning = {
				{Transition = {"Any", "Right"},	Sequence = {{C = {{"Arg", 424, "from",  1.0,  "to",   -1.0, "speed", 1.0},},},},},
				{Transition = {"Any", "Left"},	Sequence = {{C = {{"Arg", 424, "from", -1.0,  "to",    1.0, "speed", 1.0},},},},},
			},
			HeadLights = {
                {Transition = {"Any", "Retract"},   Sequence = {{C = {{"Arg", 209, "to", 0.0, "speed", 1.0},
																	{"Arg", 423, "to", 0.0, "speed", 0.5},
																	{"Arg", 424, "to", 0.0, "speed", 0.5},},},},},
                {Transition = {"Any", "Taxi"}, 		Sequence = {{C = {{"Arg", 209, "to", 1.0, "speed", 0.5},
																	{"Arg", 423, "to", 0.95, "speed", 0.5},
																	{"Arg", 424, "to", 0.0, "speed", 0.5},},},},},
				{Transition = {"Any", "High"}, 		Sequence = {{C = {{"Arg", 209, "to", 1.0, "speed", 0.5},
																	{"Arg", 423, "to", 0.7, "speed", 0.1},
																	{"Arg", 424, "to", 0.0, "speed", 0.5},},},},},
				{Transition = {"Retract", "Taxi"}, 	Sequence = {{C = {{"Arg", 209,"from", 0.0, "to", 1.0, "in", 10.0},
																	{"Arg", 423, "to", 0.95, "speed", 0.5}},},},Flags = {"Reversible"}},
				{Transition = {"High", "Taxi"}, 	Sequence = {{C = {{"Arg", 209, "to", 1.0, "in", 0.5},
																	{"Arg", 423,"from", 0.7, "to", 0.95,  "in", 3.0}},},},Flags = {"Reversible"}},
				{Transition = {"Taxi", "High"}, 	Sequence = {{C = {{"Arg", 209, "to", 1.0, "in",  10.0},
																	{"Arg", 423,"from", 0.95, "to", 0.7,  "in",   5.0}},},},Flags = {"Reversible"}},
            },
			ServiceHatches = {
				{Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 1200.0}}}, {C = {{"Arg", 428, "to", 1.0, "speed", 0.6}}}}},
				{Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 1200.0}}}, {C = {{"Arg", 428, "to", 0.0, "speed", 0.6}}}}},
			},

	}, -- end of mechanimations
	net_animation =
	{
		-- arguments to be synced to phantom
	--	19,		-- gun turret az
	--	20,		-- gun turret el
	--	350,		-- gun turret rollback
	--	349,		-- gun turret shellsmovement

		449,		-- left AADS yaw
		450,		-- left AADS pitch
		530,		-- right AADS yaw
		531,		-- right AADS pitch

		600,		-- PNVS az
		605,		-- FCR/RFI

		2,		-- tail wheel yaw
		11, 12,		-- cyclic stick
		15, 16,		-- stabilizer

		306, 307,	-- TADS turret

		509, 519,	-- NVG
		552, 553,	-- mask
		506, 507, 508,	-- PLT helmet kit
		516, 517, 518,	-- CPG helmet kit
		459, 460,	-- died/alive
		529, 549,	-- helmet correction
		546, 547, 548,	-- CPG works with...
		550, 551,	-- hands on stick
		39, 99,		-- PLT head turn
		337, 399,	-- CPG head turn

		50, 472,	-- show crew bodies
	},

	fires_pos =
	{
		[1]		= {  0,	   0,	 0},
		[2]		= { -1.73, 0.19,-0.916},
		[3]		= { -1.73, 0.19, 0.916},
		[4]		= { -7.4, -0.72, 0},
		[5]		= {  0.47,-0.39, 0},
		[6]		= { -1.17,-0.4,	 0},
		[7]		= {  0,	   0,	 0},
		[8]		= {  0,	   0,	 0},
		[9]		= {  0,	   0,	 0},
		[10]	        = {  0,	   0,	 0},
		[11]	        = {  0,	   0,	 0},
	},

	--effects_presets =
	--{
	--
	--},

	chaff_flare_dispenser =
	{
		[1] =		-- flare
		{
			dir	= {  0.821, -0.191, -0.537 },
			pos	= { -5.857, -0.301, -0.543 },
		},
		[2] =		-- flare
		{
			dir	= {  0.821, -0.191, 0.537 },
			pos	= { -5.857, -0.301, 0.542 },
		},
		[3] =		-- chaff
		{
			dir	= { -0.484,  0.750, -0.451 },
			pos	= { -7.339, -0.169, -0.456 },
		},
	},

	Failures =
	{
		-- electric system
		--{ id = 'Failure_Elec_UtilityBattery',		label = _('Utility Battery FAILURE'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  { id = 'APU_Fire',				label = _('APU Fire'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  { id = 'LeftEngine_Fire',			label = _('Engine 1 Fire'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  { id = 'RightEngine_Fire',			label = _('Engine 2 Fire'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},

	Damage = verbose_to_dmg_properties(
	{
		["GUN"]					= { args = {610}, critical_damage = 3, detachable = { shape = "AH-64D_gun" } },

		["NOSE_CENTER"]				= { args = {82}, critical_damage = 2 },	-- turret

		["RADAR"]				= { args = {146}, critical_damage = 2 },

		["COCKPIT"]				= { args = {65}, critical_damage = 3 },
		["CABIN_BOTTOM"]			= { args = {300}, critical_damage = 3 },

		["NOSE_LEFT_SIDE"]			= { args = {150}, critical_damage = 3 },
		["NOSE_RIGHT_SIDE"]			= { args = {149}, critical_damage = 3 },
		["LEFT_GEAR_BOX"]			= { args = {257}, critical_damage = 3 },
		["RIGHT_GEAR_BOX"]			= { args = {256}, critical_damage = 3 },
		["NOSE_BOTTOM"]				= { args = {148}, critical_damage = 3 },

		["FUSELAGE_TOP"]			= { args = {151}, critical_damage = 3 },
		["FUSELAGE_LEFT_SIDE"]		= { args = {154}, critical_damage = 5 },
		["FUSELAGE_RIGHT_SIDE"]		= { args = {153}, critical_damage = 5 },
		["WING_L_PART_IN"]			= { args = {227}, critical_damage = 3 },
		["WING_R_PART_IN"]			= { args = {226}, critical_damage = 3 },
		["FUSELAGE_BOTTOM"]			= { args = {152}, critical_damage = 3 },

		["WHEEL_F"]				= { args = {264}, critical_damage = 3, detachable = { shape = "AH-64D_tail" } },
		["WHEEL_L"]				= { args = {259}, critical_damage = 3 },
		["WHEEL_R"]				= { args = {255}, critical_damage = 3 },

		["ENGINE_L"]				= { args = {166}, critical_damage = 3 },
		["ENGINE_R"]				= { args = {160}, critical_damage = 3 },

		["WING_L_IN"]				= { args = {225}, critical_damage = 5, deps_cells = {"WING_L_OUT"}, detachable = { shape = "AH-64D_wing_l" } },
		["WING_L_OUT"]				= { args = {224}, critical_damage = 5, detachable = { shape = "AH-64D_wing_l" } },

		["WING_R_IN"]				= { args = {215}, critical_damage = 5, deps_cells = {"WING_R_OUT"}, detachable = { shape = "AH-64D_wing_r" } },
		["WING_R_OUT"]				= { args = {214}, critical_damage = 5, detachable = { shape = "AH-64D_wing_r" } },

		["TAIL_TOP"]				= { args = {155}, critical_damage = 5 },
		["TAIL_LEFT_SIDE"]			= { args = {158}, critical_damage = 5 },
		["TAIL_RIGHT_SIDE"]			= { args = {157}, critical_damage = 5 },
		["TAIL_BOTTOM"]				= { args = {156}, critical_damage = 5 },

		["KEEL_L"]				= { args = {245}, critical_damage = 3, deps_cells = {"TAIL"} , detachable = { shape = "AH-64D_tail" }},
		["KEEL_R"]				= { args = {242}, critical_damage = 3, deps_cells = {"TAIL"} , detachable = { shape = "AH-64D_tail" }},
		["TAIL"]				= { args = {81}, critical_damage = 3 , deps_cells = {"KEEL_CENTER"} },	-- virtual

		["KEEL_CENTER"]				= { args = {61}, critical_damage = 3, deps_cells = {"KEEL_OUT", "STABILIZATOR_L", "WHEEL_F", "TAIL_ROTOR"}, detachable = { shape = "AH-64D_tail" } },
		["KEEL_OUT"]				= { args = {62}, critical_damage = 3, deps_cells = {"TAIL_ROTOR"} },

		["STABILIZATOR_L"]			= { args = {63}, critical_damage = 3, detachable = { shape = "AH-64D_tail" } },

		["TAIL_ROTOR"]				= { args = {238}, critical_damage = 5, detachable = { shape = "AH-64D_tail" } },	-- tail rotor :)

		["ROTOR"]				= { --[[args = {146},]] critical_damage = 20, deps_cells = {"BLADE_1_IN", "BLADE_2_IN", "BLADE_3_IN", "BLADE_4_IN", "RADAR"} },

		["BLADE_1_IN"]				= { --[[args = {},]] critical_damage = 4, deps_cells = {"BLADE_1_CENTER", "BLADE_1_OUT"} },
		["BLADE_1_CENTER"]			= { args = {117}, critical_damage = 3, deps_cells = {"BLADE_1_OUT"} },
		["BLADE_1_OUT"]				= { args = {116}, critical_damage = 2, damage_boundary = 1.0 },

		["BLADE_2_IN"]				= { --[[args = {},]] critical_damage = 4, deps_cells = {"BLADE_2_CENTER", "BLADE_2_OUT"} },
		["BLADE_2_CENTER"]			= { args = {120}, critical_damage = 3, deps_cells = {"BLADE_2_OUT"} },
		["BLADE_2_OUT"]				= { args = {119}, critical_damage = 2, damage_boundary = 1.0 },

		["BLADE_3_IN"]				= { --[[args = {},]] critical_damage = 4, deps_cells = {"BLADE_3_CENTER", "BLADE_3_OUT"} },
		["BLADE_3_CENTER"]			= { args = {123}, critical_damage = 3, deps_cells = {"BLADE_3_OUT"} },
		["BLADE_3_OUT"]				= { args = {122}, critical_damage = 2, damage_boundary = 1.0 },

		["BLADE_4_IN"]				= { --[[args = {},]] critical_damage = 4, deps_cells = {"BLADE_4_CENTER", "BLADE_4_OUT"} },
		["BLADE_4_CENTER"]			= { args = {126}, critical_damage = 3, deps_cells = {"BLADE_4_OUT"} },
		["BLADE_4_OUT"]				= { args = {125}, critical_damage = 2, damage_boundary = 1.0 },

		["CREW_1"]				= { --[[args = {},]] critical_damage = 1 },
		["CREW_2"]				= { --[[args = {},]] critical_damage = 1 },

		-- additional non-standard
		["WHEEL_P_L"]				= { --[[args = {},]] critical_damage = 1 },
		["WHEEL_P_R"]				= { --[[args = {},]] critical_damage = 1 },
		["WHEEL_P_REAR"]			= { --[[args = {},]] critical_damage = 1 },

	}),-- end of Damage

	DamageParts =
	{
		-- deprecated table,
		-- "detachable" are used in Damage table
	},

SFM_Data = {
	aerodynamics =
	{
	Cy0		=0,
	Mzalfa		=4.695,
	Mzalfadt	=1.9,
	kjx		=3.4,
	kjz		=1.714,
	Czbe		=-1.6,
	cx_gear		=1.260,
	cx_flap		=0.2,
	cy_flap		=0.2,
	cx_brk		=0.1,
	table_data =
	{
			
	[1] = {0.0,0.016500,0.070000,0.132000,0.032000,1.200000,30.000000,1.200000},
        [2] = {0.2,0.016500,0.070000,0.132350,0.032000,1.500000,30.000000,1.200000},
	[3] = {0.4,0.016500,0.071050,0.132650,0.035850,2.500000,30.000000,1.200000},
	[4] = {0.6,0.016675,0.073000,0.133350,0.039850,3.150000,29.533333,1.193000},
	[5] = {0.7,0.019275,0.076000,0.134700,0.046750,3.500000,28.666667,1.180000},
	[6] = {0.8,0.027500,0.079350,0.138050,0.051650,3.500000,27.333333,1.160000},
	[7] = {0.9,0.042400,0.082300,0.153850,0.070600,3.500000,26.000000,1.140000},
	[8] = {1.0,0.054300,0.084475,0.173175,0.083550,3.500000,24.900000,1.123500},
	[9] = {1.1,0.061000,0.085500,0.197500,0.095000,3.377500,22.133333,1.110000},
	[10] ={1.1,0.057200,0.084775,0.213425,0.102250,3.027500,19.750000,1.086000},
	[11] ={1.2,0.052400,0.081950,0.226600,0.127000,2.450000,17.000000,1.050000},
	[12] ={1.3,0.047050,0.073850,0.238750,0.163000,1.911875,15.352500,0.984250},
	[13] ={1.5,0.044666,0.067069,0.245976,0.191532,1.591250,14.095000,0.936500},
	[14] ={1.5,0.043260,0.058052,0.248285,0.244419,1.294375,12.702500,0.831750},
	[15] ={1.7,0.042306,0.052968,0.244790,0.301613,1.096000,12.140000,0.749000},
	[16] ={1.8,0.041689,0.045356,0.234942,1.101677,0.846000,11.190000,0.619000},
	[17] ={2.0,0.041300,0.039700,0.230050,2.003000,0.780000,10.200000,0.520000},
	[18] ={2.2,0.040650,0.035400,0.233300,3.410000,0.728000,9.420000,0.442000},
	[19] ={2.5,0.038300,0.033350,0.276950,4.570000,0.700000,9.000000,0.400000},
	[20] ={3.9,0.037800,0.033000,0.280000,4.950000,0.700000,9.000000,0.400000},

	}, -- end of table_data
	}, -- end of aerodynamics


	engine =
		{
	Nmg	=	35,     -- RPM at idle
	MinRUD	=	0,      -- Min state of the РУД
	MaxRUD	=	1,      -- Max state of the РУД
	MaksRUD	=	1,      -- Military power state of the РУД
	ForsRUD	=	1,      -- Afterburner state of the РУД

	type	= "TurboShaft",

	hMaxEng	=	19,     -- Max altitude for safe engine operation in km
	dcx_eng	=	0.0134, -- Engine drag coeficient
	cemax	=	1.24, 
	cefor	=	2.56,
	dpdh_m	=	1461, 
	dpdh_f	=	1461, 
	table_data =
	    {--M     Pmax	 Pfor
	    {0.00,  25441.0,   25441.0},  
            {0.00,  25235.0,   25235.0},  
            {0.05,  25338.0,   25338.0},  
            {0.10,  25441.0,   25441.0},  
            {0.12,  25429.49,  25429.49}, 
            {0.15,  25405.98,  25405.98}, 
            {0.18,  25304.53,  25304.53}, 
            {0.20,  25203.07,  25203.07}, 
            {0.23,  24816.82,  24816.82}, 
            {0.25,  24430.57,  24430.57}, 
            {0.28,  24051.02,  24051.02},
            {0.30,  23671.46,  23671.46}, 
            {0.33,  23389.24,  23389.24}, 
            {0.35,  23107.02,  23107.02}, 
            {0.38,  22901.02,  22901.02}, 
            {0.40,  22695.02,  22695.02}, 
            {0.43,  22518.89,  22518.89}, 
            {0.45,  22342.76,  22342.76}, 
            {0.48,  22160.92,  22160.92}, 
            {0.50,  22079.08,  22079.08}, 
            {0.53,  22012.13,  22012.13}, 
            {0.55,  21945.18,  21945.18}, 
            {0.58,  21869.43,  21869.43}, 
            {0.60,  21893.68,  21893.68}, 
            {0.63,  21890.59,  21890.59}, 
            {0.65,  21887.5,   21887.5},  
            {0.66,  21888.83,  21888.83}, 
            {0.67,  21910.16,  21910.16}, 
            {0.69,  21948.79,  21948.79}, 
            {0.70,  21987.41,  21987.41}, 
            {0.71,  22031.7,   22031.7}, 
            {0.72,  22075.99,  22075.99},
            {0.74,  22194.69,  22194.69}, 
            {0.75,  22261.39,  22261.39}, 
            {0.76,  22339.16,  22339.16}, 
            {0.77,  22416.92,  22416.92}, 
            {0.78,  22507.05,  22507.05}, 
            {0.79,  22597.17,  22597.17}, 
            {0.80,  22695.02,  22695.02}, 
            {0.81,  22797.63,  22797.63}, 
            {0.82,  22900.23,  22900.23}, 
            {0.83,  23022.56,  23022.56}, 
            {0.84,  23143.07,  23143.07}, 
            {0.85,  23283.88,  23283.88}, 
            {0.86,  23404.69,  23404.69}, 
            {0.87,  23544.77,  23544.77}, 
            {0.88,  23685.88,  23685.88}, 
            {0.89,  23819.78,  23819.78}, 
            {0.90,  23939.26,  23939.26}, 
            {0.91,  24033.51,  24033.51}, 
            {0.92,  24127.75,  24127.75}, 
            {0.93,  24212.73,  24212.73}, 
            {0.94,  24297.7,   24297.7}, 
            {0.95,  24395.55,  24395.55}, 
            {0.96,  24500.61,  24500.61}, 
            {0.97,  24610.82,  24610.82}, 
            {0.98,  24721.03,  24721.03}, 
            {0.99,  24826.09,  24826.09}, 
            {1.00,  24924.97,  24924.97}, 
            {1.01,  25013.55,  25013.55}, 
            {1.02,  25097.81,  25097.81}, 
            {1.03,  25182.07,  25182.07}, 
            {1.04,  25275.17,  25275.17}, 
            {1.05,  25380.66,  25380.66}, 
            {1.06,  25508.55,  25508.55}, 
            {1.07,  25660.39,  25660.39}, 
            {1.08,  25846.82,  25846.82}, 
            {1.09,  26070.16,  26070.16}, 
            {1.10,  26343.28,  26343.28}, 
	    }, -- end of table_data
	       -- M - Mach number
	       -- Pmax - Engine thrust at military power
	       -- Pfor - Engine thrust at AFB
            }, -- end of engine

			
	},


	lights_data =
	{
		typename =	"collection",
		lights	=
		{
			[WOLALIGHT_STROBES]	=
			{
				typename = "collection",
				lights =
				{
					{typename = "argumentlight",	argument = 193,		controller = "Strobe", period = 1.7, flash_time = 0.05, phase_shift = 0.5},		-- anticollision light: left red
					{typename = "argumentlight",	argument = 194,		controller = "Strobe", period = 1.7, flash_time = 0.05},						-- anticollision light: right red
				},
			},--must be collection
			[WOLALIGHT_SPOTS]	=
			{
				typename = "collection",
				lights =
				{
					{typename = "argumentlight",	argument  = 209},		-- search/landing light
				},
			},--must be collection
			[WOLALIGHT_NAVLIGHTS]	=
			{
				typename = "collection",
				lights =
				{
					{typename = "argumentlight",	argument  = 190},		-- navigation lights: left red
					{typename = "argumentlight",	argument  = 191},		-- navigation lights: right green
					{typename = "argumentlight",	argument  = 192},		-- navigation lights: tail white
				},
			},--must be collection
			[WOLALIGHT_FORMATION_LIGHTS]	=
			{
				typename = "collection",
				lights =
				{
					{typename = "argumentlight",	argument  = 200},		-- formation lights
				},
			},--must be collection
			[WOLALIGHT_AUX_LIGHTS]	=
			{
				typename = "collection",
				lights =
				{
					{typename = "argumentlight",	argument = 195,		controller = "Strobe", period = 1.7, flash_time = 0.05, phase_shift = 0.5},		-- anticollision light: left white
					{typename = "argumentlight",	argument = 196,		controller = "Strobe", period = 1.7, flash_time = 0.05},						-- anticollision light: right white
				},
			},--must be collection
		}, -- end of lights
	},-- end of lights_data

	-- Aircraft Additional Properties

	AddPropAircraft = {
		{ id = "PltNVG" , control = 'checkbox', label = _('Allow Plt NVG'), defValue = true, arg = 509},
		{ id = "CpgNVG" , control = 'checkbox', label = _('Allow Cpg NVG'), defValue = true, arg = 519},
		addComboList("FlareBurstCount",			_('Flare Burst Count'), 					{"1","2","3","4","6","8"}),
		addComboList("FlareBurstInterval",		_('Flare Burst Interval, [sec]'), 			{"0.1","0.2","0.3","0.4"}),
		addComboList("FlareSalvoCount",			_('Flare Salvo Count'), 					{"1","2","4","8",_("Continuous")}),
		addComboList("FlareSalvoInterval",		_('Flare Salvo Interval, [sec]'), 			{"1","2","3","4","5","8",_("Random")}),
		addComboList("FlareProgramDelay",		_('Flare Delay betw Programs, [sec]'), 		{"1","2","3","4"}),
					-- AI HELPER SECTION
		{ id = "mul_Label", control = 'label', label = _('AI HELPER'), xLbl = 150,},
		{ id = "OverrideIFF",
			control = 'comboList',
			label = _('AI IFF Detection Mode'),
			playerOnly = true,
			values = {
				{id = 0, dispName = _("Auto")},
				{id = 1, dispName = _("Simple")},
				{id = 2, dispName = _("Label Only")},
				{id = 3, dispName = _("Realistic")}
			},
			defValue  = 0,
			wCtrl = 150,
		},
		{ id = "TrackAirTargets" , control = 'checkbox', label = _('Track air targets','Track Air Targets'), defValue = true},
					-- MULTIPLAYER SECTION
		{ id = "mul_Label", control = 'label', label = _('MULTIPLAYER'), xLbl = 150,},
		{ id = "NetCrewControlPriority",
			control = 'comboList',
			label = _('Aircraft Control Priority'),
			playerOnly = true,
			values = {
				{id =  0, dispName = _("Pilot")},
				{id =  1, dispName = _("CPG")},
				{id = -1, dispName = _("Ask Always")},
				{id = -2, dispName = _("Equally Responsible")}
			},
			defValue  = 0,
			wCtrl = 150,
		},
		{ id = "AIDisabled" , control = 'checkbox', label = _('AI Disabled'), defValue = false},
		{ id = "HumanOrchestra"  , control = 'checkbox', label = _('Disable Multicrew'), defValue = false, playerOnly = true, },
		---------DATALINK--------------------------------------------------------------------------
		{ id = "dataluink_Label", control = 'label', label = _('DATALINK'), xLbl = 150},

		{ id = "TN_IDM_LB" , control = 'editbox', label = _('Datalink Originator ID'), getDefault = getLongbowId,  onChange = LB_OrigIDOnChange, onFocus = onFocus_OrigID},
		{ id = "OwnshipCallSign" , control = 'editbox', label = _('Ownship CallSign'), getDefault = getCallsign, onChange = OwnshipCallSignOnChange, onFocus = onFocus_Callsign},
	},

	connectDatalinks = {
        "IDM",
    },

	datalinks = {
		IDM = "CoreMods\\aircraft\\AH-64D\\Datalinks\\IDM.lua",
		--Link16
		--Link4
		--SADL
	},

	visualIR = {
		coeffs = {	-- heat collect coef, heat loose coef, texture_coef, texture_base_val
					{0.02, 	0.01,  1.0, 0.0}, -- engines and equipment
					{ 0.1, 	0.01,  1.0, -0.1}, -- aerodynamic heat - edges for fixed wing, rotors blades for heli
					{0.003, 0.05,  1.0, 0.0}, -- weapon/canon
					{0.01, 	0.02,  4.0, 0.1}	-- overall hull -> environment
				 }
				},

	input_profile_entry = "AH-64D_BLK_II_PLT",

	InheriteCommonCallnames = true,
	SpecificCallnames = {
		["USA"] = {
					{_('ArmyAir'),			'Army_Air'},
					{_('Apache'),			'Apache'},
					{_('Crow'),			'Crow'},
					{_('Chaos'),			'Chaos'},
					{_('Sioux'),			'Sioux'},
					{_('Gatling'),			'Gatling'},
					{_('Gunslinger'),		'Gunslinger'},
					{_('Hammerhead'),		'Hammerhead'},
					{_('Bootleg'),			'Bootleg'},
					{_('Palehorse'),		'Palehorse'},
					{_('Carnivore'),		'Carnivore'},
					{_('Saber'),			'Saber'}
		}
	},

	rotor_animation =
	{
		tail_rotor =
		{
			blades_count	= 2,
			modelBlade_FBX 	= "/models/ah-64d_blade.FBX",
			rotor_direction = -1,
			rotor_locations = {
				{	pos = {-8.7854, 2.10865,-0.833885},yaw = math.rad(90)},
				{	pos = {-8.7854, 2.10865,-0.695485},yaw = math.rad(90)},
			},
		},
		rotor_locations	= {{POSITION_WILL_BE_TAKEN_FROM_CONNECTOR}},--{{pos   = {0.316565, 2.13449, 0}}},
		rotor_models 	=
		{{
			modelRotorHub_EDM  		=  "AH-64D_rotor_hub",
			modelRotorHubLod_FBX 	=  "/models/AH-64D_rotor_hub_lod.fbx",
			boundRotorHub_FBX		=  "/models/AH-64D_rotor_hub_bound.FBX",
			boundBlade_FBX			=  "/models/AH-64D_rotor_blade_bound.fbx",
			modelBlade_FBX 			= {"/models/AH-64D_rotor_blade.fbx", "/models/AH-64D_rotor_blade_damage_1.fbx", "/models/AH-64D_rotor_blade_damage_2.fbx" },
		}}
	},
}

add_aircraft(AH_64D)